clc;
clear all;
h=99*10^(-9);
m=1;
kx=2*pi*m/h;
c=3*(10^8);
lambda=400:1:1200;
lamda=lambda*(10^(-9));

%Lines 13,19,39,42,46 are for amorphous HMM and lines 15,21,40,43,47 are
%for crystalline HMM
layer1NK_F = importdata('Ge_Palik_WVASE.txt');
 
layer2NK_F=importdata('GST_NK_24nm_GST_HMM_7period_oldtarget_amorphous_model10_fit1_CEase.txt');

% layer2NK_F=importdata('GST_NK_24nm_GST_HMM_7period_oldtarget_crystalline_model9B_fit1_CEase.txt');

layer3NK_F = importdata('Ag_Palik_CompEASE.txt');

layer4EPS_F = importdata('Intermix_EPS_11p7nm_GST_HMM_7period_oldtarget_amorphous_model10_fit1_CEase.txt');

% layer4EPS_F = importdata('Intermix_EPS_6p2nm_GST_HMM_7period_oldtarget_crystalline_model9B_fit1_CEase.txt');


layer1NK = interp1(layer1NK_F(:,1),layer1NK_F(:,2),lambda,'spline')+1i*interp1(layer1NK_F(:,1),layer1NK_F(:,3),lambda, 'spline');
layer2NK = interp1(layer2NK_F(:,1),layer2NK_F(:,2),lambda,'spline')+1i*interp1(layer2NK_F(:,1),layer2NK_F(:,3),lambda, 'spline');
 layer3NK = interp1(layer3NK_F(:,1),layer3NK_F(:,2),lambda,'spline')+1i*interp1(layer3NK_F(:,1),layer3NK_F(:,3),lambda, 'spline');
 layer4EPS = interp1(layer4EPS_F(:,1),layer4EPS_F(:,2),lambda,'spline')+1i*interp1(layer4EPS_F(:,1),layer4EPS_F(:,3),lambda, 'spline');
 
w=2*pi*c./lamda;
e1=layer1NK.^2;%epsilon 1
e2=layer2NK.^2;%epsilon 2
e3=layer3NK.^2;%epsilon 3
e4=layer4EPS;
% e3=layer3NK;%epsilon 3

t1=1*(10^(-9));%thickness 1


t2= 18.15*(10^(-9));%thickness 2 for amorphous HMM
% t2= 20.9*(10^(-9));%thickness 2 for crystalline HMM

t3= 9.15*(10^(-9));%thickness 3 for amorphous HMM
% t3= 11.9*(10^(-9));%thickness 3 for crystalline HMM


t4=11.7*(10^(-9));%thickness 4 for Amorphous HMM
% t4=6.2*(10^(-9));%thickness 4 for crystalline HMM

% epsx_0 = (t1+t2+t3)./((t1./e1)+ (t2./e2)+ (t3./e3));
% epsyz_0=((t1.*e1)+(t2.*e2)+(t3.*e3))./(t1+t2+t3);
% 
epsx_0 = (t1+t2+t3+t4)./((t1./e1)+ (t2./e2)+ (t3./e3)+(t4./e4));
epsyz_0=((t1.*e1)+(t2.*e2)+(t3.*e3)+(t4.*e4))./(t1+t2+t3+t4);



% plot(lambda,[real(epsyz_0);imag(epsyz_0);real(epsx_0);imag(epsx_0)]);
% legend('real epar','imag epar','real eper','imag eper');
figure;
plot(lambda,[real(epsyz_0);real(epsx_0)]);
legend('real epar','real eper');

E=[lambda;real(epsyz_0);imag(epsyz_0)];

F=[lambda;imag(epsyz_0)];

G=[lambda;real(epsx_0);imag(epsx_0)];

H=[lambda;imag(epsx_0)];

%J=[lambda;eta];
f_format = '%6.2f';
fid = fopen('epar0_real.dat','w');
         fprintf(fid, '%12.8f %12.8f\n',E);
fclose(fid);
fid = fopen('epar0_imag.dat','w');
         fprintf(fid, '%12.8f %12.8f\n',F);
fclose(fid);
fid = fopen('eper0_real.dat','w');
         fprintf(fid, '%12.8f %12.8f\n',G);
fclose(fid);
fid = fopen('eper0_imag.dat','w');
         fprintf(fid, '%12.8f %12.8f\n',H);
fclose(fid);
% fid = fopen('eta','w');
%          fprintf(fid, '%12.8f %12.8f\n',J);
% fclose(fid);
%the following part writes the interpolated n and k values of Ag (layer 1)and TiO2 (layer 2) to .dat files
K=[lambda;real(layer1NK)];
fid = fopen('layer1NK_real.dat','w');
         fprintf(fid, '%12.8f %12.8f\n',K);
fclose(fid);         
L=[lambda;imag(layer1NK)];
fid = fopen('layer1NK_imag.dat','w');
         fprintf(fid, '%12.8f %12.8f\n',L);
fclose(fid);         
% M=[lambda;real(layer2NK)];
% fid = fopen('layer2NK_real.dat','w');
%          fprintf(fid, '%12.8f %12.8f\n',M);
% fclose(fid);         
% N=[lambda;imag(layer2NK)];
% fid = fopen('layer2NK_imag.dat','w');
%          fprintf(fid, '%12.8f %12.8f\n',N);
% fclose(fid);         
